import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

public class testEvent3 extends MIDlet {

  // Dfinit le Display
  Display display;
  // Dfinit la commande de sortie
  Command cmdSortie;

  /**
   *  Constructeur
  **/
  public testEvent3() {
    display = Display.getDisplay (this);
  }

  /**
   *  Lance le MIDlet
  **/
  public void startApp () {
    display = Display.getDisplay (this);

    // Dfinit une classe anonyme
    Canvas canvas = new Canvas() { 

      /**
       *  Dessine le contenu de l'cran
      **/
      public void paint (Graphics g) {
      }

      /**
       *  Gre les vnements de pression de touche
      **/
      protected void keyPressed (int keyCode) {
        if (keyCode > 0) {
          // Une touche a t presse.
          System.out.println ("keyPressed " + ((char) keyCode));
        } else {
          // Une touche d'action a t presse
          System.out.println ("Action keyPressed " + getGameAction (keyCode));
          int action = getGameAction (keyCode);
          switch (action) {
            case LEFT:
              // Il s'agit de l'action "aller vers la gauche"
              System.out.println ("Vers la gauche");
              break;
            case RIGHT:
              // Il s'agit de l'action "aller vers la droite"
              System.out.println ("Vers la droite");
              break;
          }
        }                  
      }

      /**
       *  Gre les vnements de relchement de touche
      **/
      protected void keyReleased (int keyCode) {
        if (keyCode > 0) {
          // Une touche a t relche
          System.out.println ("keyReleased " + ((char) keyCode));
        } else {
          // Une touche d'action a t relche
          System.out.println ("Action keyReleased " + getGameAction (keyCode));
        } 
      }
    };

    // Ajoute une commande de sortie
    cmdSortie = new Command ("Sortie", Command.STOP, 1);
    canvas.addCommand (cmdSortie);
    // Met en place le listener
    canvas.setCommandListener (new CommandListener() {

      /**
       *  Gre les vnements d'activation de commande
      **/
      public void commandAction (Command cmdSelected, Displayable d) {
        // Si la commande de sortie a t slectionne, termine le MIDlet
        if (cmdSelected == cmdSortie) {
          notifyDestroyed();
        } else {
          // Si ce n'est pas la commande de sortie, affiche le libell
          // de cette commande.
          System.out.println ("Commande " + cmdSelected);
        }
      }
    });
    display.setCurrent (canvas);
  }

  /**
   *  Suspend l'excution du MIDlet
  **/
  public void pauseApp () {
  }

  /**
   *  Libre les ressources
  **/
  public void destroyApp (boolean unconditional) {
  }
}
